@echo off
chcp 936
setlocal enabledelayedexpansion

rem ========== Configuration ==========
set backup_dir=C:\ݿⱸ
set log_file=%backup_dir%\cleanup_log.txt
set days=7

rem ========== Create log header ==========
echo ================================= > "%log_file%"
echo Cleanup start: %date% %time% >> "%log_file%"
echo Backup directory: %backup_dir% >> "%log_file%"
echo Keep days: %days% >> "%log_file%"

rem ========== Get current date (simpler method) ==========
echo Getting current date...
set year=%date:~0,4%
set month=%date:~5,2%
set day=%date:~8,2%

rem If date format is different, try alternative
if "%year%%month%%day%"=="    " (
    rem Alternative method
    for /f "tokens=1-3 delims=/ " %%a in ("%date%") do (
        set year=%%a
        set month=%%b
        set day=%%c
    )
)

set current_date=%year%%month%%day%
echo Current date: %current_date% >> "%log_file%"

rem ========== Calculate cutoff date ==========
echo Calculating cutoff date...
set /a cutoff_year=%year%
set /a cutoff_month=%month%
set /a cutoff_day=%day% - %days%

:adjust_date
if %cutoff_day% lss 1 (
    set /a cutoff_month-=1
    if %cutoff_month% lss 1 (
        set /a cutoff_year-=1
        set /a cutoff_month=12
    )
    
    rem Get days in previous month
    if %cutoff_month% equ 2 (
        set /a days_in_month=28
    ) else if %cutoff_month% equ 4 (
        set /a days_in_month=30
    ) else if %cutoff_month% equ 6 (
        set /a days_in_month=30
    ) else if %cutoff_month% equ 9 (
        set /a days_in_month=30
    ) else if %cutoff_month% equ 11 (
        set /a days_in_month=30
    ) else (
        set /a days_in_month=31
    )
    
    set /a cutoff_day=days_in_month + cutoff_day
    goto adjust_date
)

rem Format with leading zeros
if %cutoff_month% lss 10 set cutoff_month=0%cutoff_month%
if %cutoff_day% lss 10 set cutoff_day=0%cutoff_day%

set cutoff_date=%cutoff_year%%cutoff_month%%cutoff_day%
echo Cutoff date: %cutoff_date% (delete folders before this) >> "%log_file%"
echo Today: %current_date% >> "%log_file%"
echo Delete before: %cutoff_date% >> "%log_file%"

rem ========== Debug info ==========
echo DEBUG INFO: >> "%log_file%"
echo Today folders should be KEPT >> "%log_file%"
echo Folders older than %cutoff_date% should be DELETED >> "%log_file%"

rem ========== Start cleanup ==========
echo Starting scan and delete... >> "%log_file%"
set deleted_count=0
set error_count=0

for /d %%d in ("%backup_dir%\*") do (
    set folder_name=%%~nxd
    
    rem Check if 8-digit number (date folder)
    echo !folder_name!|findstr /r "^[0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]$" >nul
    if !errorlevel! equ 0 (
        echo Processing date folder: !folder_name! >> "%log_file%"
        
        if !folder_name! lss %cutoff_date% (
            echo DELETE: !folder_name! is older than %cutoff_date% >> "%log_file%"
            echo Deleting folder: !folder_name! ...
            rd /s /q "%%d"
            if exist "%%d" (
                echo Delete FAILED: !folder_name! >> "%log_file%"
                set /a error_count+=1
            ) else (
                echo Delete SUCCESS: !folder_name! >> "%log_file%"
                set /a deleted_count+=1
            )
        ) else (
            echo KEEP: !folder_name! is newer than or equal to %cutoff_date% >> "%log_file%"
        )
    ) else (
        echo Skip non-date folder: !folder_name! >> "%log_file%"
    )
)

rem ========== Log results ==========
echo. >> "%log_file%"
echo ========== SUMMARY ========== >> "%log_file%"
echo Cleanup completed at: %time% >> "%log_file%"
echo Successfully deleted: %deleted_count% folders >> "%log_file%"
echo Failed to delete: %error_count% folders >> "%log_file%"
echo Cutoff date was: %cutoff_date% >> "%log_file%"
echo ================================= >> "%log_file%"

echo.
echo ========== CLEANUP COMPLETED ==========
echo Check log file: %log_file%
echo Deleted: %deleted_count% folders
echo Failed: %error_count% folders
echo Cutoff date: %cutoff_date%
echo.
pause