@echo on
chcp 65001
rem 65001 代表 utf8编码
setlocal enabledelayedexpansion

rem 使用 wmic 命令获取当前日期并格式化为 YYYYMMDD
for /f "tokens=1 delims=." %%a in ('wmic os get localdatetime ^| findstr /r /c:"[0-9]"') do (
    set "datetime=%%a"
)
set "current_date=%datetime:~0,4%%datetime:~4,2%%datetime:~6,2%"

rem 定义备份目录
set "backup_dir=C:\数据库备份"

rem 创建以当前日期命名的文件夹
set "new_folder=%backup_dir%\%current_date%"
if not exist "%new_folder%" (
    mkdir "%new_folder%"
    echo 创建文件夹 %new_folder% 成功
)

rem 移动包含当前日期的文件到新文件夹
set "search_pattern=*%current_date:~0,4%_%current_date:~4,2%_%current_date:~6,2%*"
for %%f in ("%backup_dir%\%search_pattern%") do (
    if "%%~ff" neq "%new_folder%" (
        move "%%f" "%new_folder%"
        echo 移动文件 %%f 到 %new_folder% 成功
    )
)

rem 同步当天新生成的目录到华为云 OBS 的以当天日期命名的目录
echo 开始同步 %new_folder% 到 obs://abc-dba-backup/%current_date%
C:\Windows\obsutil.exe sync "%new_folder%" obs://abc-dba-backup/192.168.10.24/%current_date% > sync.log 2>&1
if %errorlevel% equ 0 (
    echo 同步 %new_folder% 到 obs://abc-dba-backup/192.168.10.24/%current_date% 成功
) else (
    echo 同步 %new_folder% 到 obs://abc-dba-backup/192.168.10.24/%current_date% 失败
    type sync.log
)

endlocal